/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************//*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : PRESETTABLE SYNCHRONOUS 4-BIT BINARY UP/DOWN  COUNTER 
TRUTHTABLE     : 
+--------------------------------+-----------------------+
|             INPUT              |                       |
+--------------------------------+       OPERATION       |
|  CLR   LOAD_   UP    DOWN      |                       |
+--------------------------------+-----------------------+
|   H      X      X      X       |   Asynchronous clear  |
|                                |                       |
|   L      L      X      X       |   Load Parrallel Data |
|                   _            |                       |
|   L      H      _/     H       |   Binary Count Up     |
|                         _      |                       |
|   L      H       H    _/       |   Binary Count Down   |
|                                |                       |
+--------------------------------+-----------------------+

   Note : 1. CO_ goes low at the maximum terminal count for 
             half clock pulse duration.
          2. BO_ goes low at the minimum terminal count for           
             half clock pulse duration.
           
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a193 (b, qb, qa, down, up, qc, qd, d, c, ldn, con, bon, clr, a);
	parameter size =1;
	input
		ldn,
		up,
		down,
		clr,
		a,
		b,
		c,
		d;
	output
		qa,
		qb,
		qc,
		qd,
		bon,
		con;
    reg
        NOTIFY_REG;
    not
	N1 (mr_, clr);
    and
	A2 (en2, ldn, mr_, down);
    and
	A3 (en3, ldn, mr_, up);
    not  
	M193_inst_I1 (m193_inst_wi1, clr);
    not  
	M193_inst_I2 (m193_inst_wi2, ldn);
    not
	M193_inst_I3 (m193_inst_wi3, a);
    not
	M193_inst_I4 (m193_inst_wi4, b);
    not
	M193_inst_I5 (m193_inst_wi5, c);
    not
	M193_inst_I6 (m193_inst_wi6, d);
    not  
	M193_inst_I7 (m193_inst_wi7, up);
    not 
	M193_inst_I8 (m193_inst_wi8, down);
    xor
	M193_inst_XO1 (m193_inst_wxo1, m193_inst_qaint, m193_inst_qbint);
    xor
	M193_inst_XO2 (m193_inst_wxo2, m193_inst_wqna, m193_inst_qbint);
    xor
	M193_inst_XO3 (m193_inst_wxo3, m193_inst_wa5, m193_inst_qcint);
    xor
	M193_inst_XO4 (m193_inst_wxo4, m193_inst_wa6, m193_inst_qcint);
    xor
	M193_inst_XO5 (m193_inst_wxo5, m193_inst_wa7, m193_inst_qdint);
    xor
	M193_inst_XO6 (m193_inst_wxo6, m193_inst_wa8, m193_inst_qdint);
    and  
	M193_inst_A1 (m193_inst_wa1, m193_inst_wna1, m193_inst_wi1);
    and  
	M193_inst_A2 (m193_inst_wa2, m193_inst_wna2, m193_inst_wi1);
    and  
	M193_inst_A3 (m193_inst_wa3, m193_inst_wna3, m193_inst_wi1);
    and  
	M193_inst_A4 (m193_inst_wa4, m193_inst_wna4, m193_inst_wi1);
    and
	M193_inst_A5 (m193_inst_wa5, m193_inst_qaint, m193_inst_qbint);
    and
	M193_inst_A6 (m193_inst_wa6, m193_inst_wqna, m193_inst_wqnb);
    and
	M193_inst_A7 (m193_inst_wa7, m193_inst_qaint, m193_inst_qbint, m193_inst_qcint);
    and
	M193_inst_A8 (m193_inst_wa8, m193_inst_wqna, m193_inst_wqnb, m193_inst_wqnc);
    and  
	M193_inst_A9 (m193_inst_wa9, up, down);
    nand
	M193_inst_NA1 (m193_inst_wna1, m193_inst_wi2, m193_inst_wi3);
    nand
	M193_inst_NA2 (m193_inst_wna2, m193_inst_wi2, m193_inst_wi4);
    nand
	M193_inst_NA3 (m193_inst_wna3, m193_inst_wi2, m193_inst_wi5);
    nand
	M193_inst_NA4 (m193_inst_wna4, m193_inst_wi2, m193_inst_wi6);
    nand  
	M193_inst_NA5 (m193_inst_wna5, a, m193_inst_wi1, m193_inst_wi2);
    nand  
	M193_inst_NA6 (m193_inst_wna6, b, m193_inst_wi1, m193_inst_wi2);
    nand  
	M193_inst_NA7 (m193_inst_wna7, c, m193_inst_wi1, m193_inst_wi2);
    nand  
	M193_inst_NA8 (m193_inst_wna8, d, m193_inst_wi1, m193_inst_wi2);
    nand  
	M193_inst_NA18 (con, m193_inst_qaint, m193_inst_qbint, m193_inst_qcint, m193_inst_qdint, m193_inst_wi7);
    nand  
	M193_inst_NA19 (bon, m193_inst_wqna, m193_inst_wqnb, m193_inst_wqnc, m193_inst_wqnd, m193_inst_wi8);
    buf  
	  (qa, m193_inst_qaint);
    buf  
	  (qb, m193_inst_qbint);
    buf 
	  (qc, m193_inst_qcint);
    buf  
	  (qd, m193_inst_qdint);
    not
	  (m193_inst_wqna, m193_inst_qaint);
    not
	  (m193_inst_wqnb, m193_inst_qbint);
    not
	  (m193_inst_wqnc, m193_inst_qcint);
    not
	  (m193_inst_wqnd, m193_inst_qdint);
    not
	  (m193_inst_wqn5, m193_inst_wq5);
    U_AO_2_2
	M193_inst_INST1_inst1 (m193_inst_wna15, m193_inst_wq5, m193_inst_wxo1, m193_inst_wxo2, m193_inst_wqn5);
    U_AO_2_2
	M193_inst_INST2_inst1 (m193_inst_wna16, m193_inst_wq5, m193_inst_wxo3, m193_inst_wxo4, m193_inst_wqn5);
    U_AO_2_2
	M193_inst_INST3_inst1 (m193_inst_wna17, m193_inst_wq5, m193_inst_wxo5, m193_inst_wxo6, m193_inst_wqn5);
    U_FD_P_RB_SB_NO
	  (m193_inst_qaint, m193_inst_wqna, m193_inst_wa9, m193_inst_wa1, m193_inst_wna5, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m193_inst_qbint, m193_inst_wna15, m193_inst_wa9, m193_inst_wa2, m193_inst_wna6, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m193_inst_qcint, m193_inst_wna16, m193_inst_wa9, m193_inst_wa3, m193_inst_wna7, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m193_inst_qdint, m193_inst_wna17, m193_inst_wa9, m193_inst_wa4, m193_inst_wna8, NOTIFY_REG);
    U_FD_P_RB_SB_NO
	  (m193_inst_wq5, 1'b0, 1'b0, down, up, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
